/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class TracePrintStream
extends PrintStream {
    public TracePrintStream(String filename) {
        super(new TraceOutputStream(filename), true);
        if (filename == "!STD") {
            System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
            System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err)));
        } else {
            System.setOut(this);
            System.setErr(this);
        }
    }

    public TracePrintStream() {
        this((String)null);
    }

    private static class TraceOutputStream
    extends OutputStream {
        private FileOutputStream fs = null;
        private byte[] buf = new byte[1014];
        private int pos = 0;
        private static final String prefix = "XFM!!!!F";

        private TraceOutputStream(String filename) {
            if (!Trace.isLibraryLoaded() && filename != null) {
                try {
                    this.fs = new FileOutputStream(filename);
                }
                catch (Exception e) {
                    System.out.println("Exception opening output file [" + filename + "]: " + e);
                    e.printStackTrace();
                }
            }
        }

        public void close() throws IOException {
            if (this.fs != null) {
                this.fs.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.flush();
                }
            } else {
                TraceOutputStream traceOutputStream = this;
                synchronized (traceOutputStream) {
                    if (this.pos > 0) {
                        Trace.trace(prefix, new String(this.buf, 0, this.pos));
                        this.pos = 0;
                    }
                }
            }
        }

        public void write(int b) throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.write(b);
                }
            } else {
                byte[] bb = new byte[]{(byte)b};
                this.write(bb, 0, 1);
            }
        }

        public void write(byte[] b) throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.write(b);
                }
            } else {
                this.write(b, 0, b.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            if (!Trace.isLibraryLoaded()) {
                if (this.fs != null) {
                    this.fs.write(b, off, len);
                }
            } else {
                TraceOutputStream traceOutputStream = this;
                synchronized (traceOutputStream) {
                    for (int i = 0; i < len; ++i) {
                        this.buf[this.pos] = b[off + i];
                        ++this.pos;
                        if (this.pos != this.buf.length) continue;
                        Trace.trace(prefix, new String(this.buf, 0, this.pos));
                        this.pos = 0;
                    }
                }
            }
        }
    }
}

